#!/bin/bash
SRC=$1
DST=$2

if [ -z "$DST" -o -n "$3" ]; then 
	echo "USAGE $0 <SRC> <DST>"
	exit -1
fi

if [ ! -d "$DST" ]; then
	echo "$DST is not a directory!"
	exit -1
fi
if [ ! -d "$SRC" ]; then
	echo "$SRC is not a directory!"
	exit -1
fi

if ! command -v realpath > /dev/null 2>&1; then
	echo "realpath command is required! use sudo apt-get install realname";
	exit -1
fi

DST_FILE="$DST/$(basename $SRC).zip"

if [ -e "$DST_FILE" ]; then
	echo "$DST_FILE already exists!"
	exit -2
fi
DST_FILE="$(realpath $DST_FILE)"

IGNORE_SUFFIXES=.Z:.zip:.tiff:.gif:.snd:.gz:.bz2:$IGNORE_SUFFIXES

echo "Going to archive $SRC to $DST_FILE (not compressing $IGNORE_SUFFIXES)";

cd $SRC
zip --symlinks -rn $IGNORE_SUFFIXES "$DST_FILE" . && par2 create "$DST_FILE.par2" "$DST_FILE"
